/*
 * Decompiled with CFR 0.152.
 */
package filenet.ws.api;

import filenet.vw.base.logging.Logger;
import filenet.ws.api.WSBinding;
import filenet.ws.api.WSBindingOperation;
import filenet.ws.api.WSDefinition;
import filenet.ws.api.WSPortType;
import filenet.ws.api.WSService;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import javax.wsdl.Binding;
import javax.wsdl.Port;
import javax.wsdl.PortType;
import javax.wsdl.extensions.http.HTTPAddress;
import javax.wsdl.extensions.soap.SOAPAddress;
import javax.xml.namespace.QName;

public class WSPort {
    protected static Logger logger = Logger.getLogger("filenet.ws.api");
    private static String m_className = "WSPort";
    private WSDefinition m_definition = null;
    private WSService m_service = null;
    private Port m_port = null;
    private WSBinding m_binding = null;
    private SOAPAddress m_soapAddress = null;
    private HTTPAddress m_httpAddress = null;

    public static String _get_FILE_DATE() {
        return "$Date:   10 Sep 2008 10:00:24  $";
    }

    public static String _get_FILE_AUTHOR() {
        return "$Author:   ysoong  $";
    }

    public static String _get_FILE_REVISION() {
        return "$Revision:   1.16  $";
    }

    public void releaseReferences() {
        block3: {
            try {
                this.m_definition = null;
                this.m_service = null;
                this.m_port = null;
                if (this.m_binding != null) {
                    WSBinding binding = this.m_binding;
                    this.m_binding = null;
                    binding.releaseReferences();
                    binding = null;
                }
                this.m_soapAddress = null;
                this.m_httpAddress = null;
            }
            catch (Exception ex) {
                if (!logger.isFinest()) break block3;
                logger.throwing(m_className, "releaseReferences", ex);
            }
        }
    }

    public WSPort(WSDefinition definition, WSService service, Port port) {
        this.m_definition = definition;
        this.m_service = service;
        this.m_port = port;
        if (this.m_port != null) {
            this.initExtensiveElements();
            if (this.m_definition != null) {
                this.m_binding = this.m_definition.getBinding(this.m_port.getBinding());
            }
        }
    }

    void initExtensiveElements() {
        Iterator it;
        List l = this.m_port.getExtensibilityElements();
        if (l != null && l.size() > 0 && (it = l.iterator()) != null) {
            while (it.hasNext()) {
                Object obj = it.next();
                if (obj == null) continue;
                if (obj instanceof SOAPAddress) {
                    this.m_soapAddress = (SOAPAddress)obj;
                    continue;
                }
                if (!(obj instanceof HTTPAddress)) continue;
                this.m_httpAddress = (HTTPAddress)obj;
            }
        }
    }

    public String getName() {
        if (this.m_port != null) {
            return this.m_port.getName();
        }
        return null;
    }

    public String getDisplayName() {
        if (this.m_port != null) {
            return this.m_port.getName();
        }
        return null;
    }

    public Port getPort() {
        return this.m_port;
    }

    public WSBinding getBinding() {
        return this.m_binding;
    }

    public String toString() {
        return this.getName();
    }

    public boolean isSamePort(String name) {
        String portName;
        return name != null && this.m_port != null && (portName = this.m_port.getName()) != null && name.compareTo(portName) == 0;
    }

    public boolean isSupportingPortType(QName name) {
        QName portTypeName;
        PortType portType;
        Binding binding;
        return name != null && this.m_binding != null && (binding = this.m_binding.getBinding()) != null && (portType = binding.getPortType()) != null && (portTypeName = portType.getQName()) != null && portTypeName.equals(name);
    }

    public boolean isSupportingPortType(String name) {
        WSPortType portType;
        if (name != null && (portType = this.m_definition.getPortType(name)) != null) {
            return this.isSupportingPortType(portType.getQName());
        }
        return false;
    }

    public WSService getService() {
        return this.m_service;
    }

    public WSBindingOperation getBindingOperation(String operation, String inputName, String outputName) {
        WSBindingOperation[] bops;
        if (operation != null && this.m_binding != null && (bops = this.m_binding.getBindingOperations()) != null) {
            if (inputName != null && inputName.trim().length() == 0) {
                inputName = null;
            }
            if (outputName != null && outputName.trim().length() == 0) {
                outputName = null;
            }
            if (bops.length == 1 && inputName == null && outputName == null) {
                return bops[0];
            }
            for (int i = 0; i < bops.length; ++i) {
                if (bops[i] == null) continue;
                String opName = bops[i].getName();
                String inName = bops[i].getInputName();
                String outName = bops[i].getOutputName();
                if (inName != null && inName.trim().length() == 0) {
                    inName = null;
                }
                if (outName != null && outName.trim().length() == 0) {
                    outName = null;
                }
                if (opName == null || opName.compareTo(operation) != 0 || (inputName != null || inName != null) && (inputName == null || inName == null || inputName.compareTo(inName) != 0) || (outputName != null || outName != null) && (outputName == null || outName == null || outputName.compareTo(outName) != 0)) continue;
                return bops[i];
            }
        }
        if (inputName == null && outputName == null) {
            return this.getBindingOperation(operation);
        }
        return null;
    }

    public WSBindingOperation[] getBindingOperations(String operation) {
        if (operation != null && this.m_binding != null) {
            Vector<WSBindingOperation> v = new Vector<WSBindingOperation>();
            WSBindingOperation[] bops = this.m_binding.getBindingOperations();
            if (bops != null) {
                for (int i = 0; i < bops.length; ++i) {
                    String opName;
                    if (bops[i] == null || (opName = bops[i].getName()) == null || opName.compareTo(operation) != 0) continue;
                    v.add(bops[i]);
                }
            }
            if (v != null && v.size() > 0) {
                WSBindingOperation[] bindingOps = new WSBindingOperation[v.size()];
                v.toArray(bindingOps);
                v.removeAllElements();
                return bindingOps;
            }
        }
        return null;
    }

    public WSBindingOperation getBindingOperation(String operation) {
        WSBindingOperation[] bops;
        if (operation != null && this.m_binding != null && (bops = this.m_binding.getBindingOperations()) != null) {
            for (int i = 0; i < bops.length; ++i) {
                String opName;
                if (bops[i] == null || (opName = bops[i].getName()) == null || opName.compareTo(operation) != 0) continue;
                return bops[i];
            }
        }
        return null;
    }

    public String getEndpoint() {
        if (this.m_soapAddress != null) {
            return this.m_soapAddress.getLocationURI();
        }
        if (this.m_httpAddress != null) {
            return this.m_httpAddress.getLocationURI();
        }
        return null;
    }

    public SOAPAddress getSoapAddress() {
        return this.m_soapAddress;
    }

    public String getSoapAddressLocationURI() {
        if (this.m_soapAddress != null) {
            return this.m_soapAddress.getLocationURI();
        }
        return null;
    }

    public String getHTTPAddressLocation() {
        if (this.m_httpAddress != null) {
            return this.m_httpAddress.getLocationURI();
        }
        return null;
    }
}

